<?php

// app/Mail/RecipeMail.php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RecipeMail extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $email;
    public $mobile;

    public function __construct($details)
    {
        $this->name = $details['name'];
        $this->email = $details['email'];
        $this->mobile = $details['mobile'];
    }

    public function build()
    {
        return $this->view('emails.recipe')
                    ->with([
                        'name' => $this->name,
                        'email' => $this->email,
                        'mobile' => $this->mobile,
                    ]);
    }
}
