<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Footer Example</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Onest:wght@500&display=swap');

        .footer-main {
            background-color: #4D1311;
            /* Background color of the footer */
            color: white;
            position: relative;
            margin-top: 250px;
            padding: 2rem;
        }

        .footer-logo {
            position: absolute;
            top: 0;
            left: 50%;
            transform: translate(-50%, -50%);
        }

        .footer-blk {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
            gap: 3rem;
            padding-top: 4rem;
            padding-left: 3rem;
            padding-right: 3rem;
        }

        .footer-sub-blk {
            margin-bottom: 2rem;
        }

        .footer-sub-blkk {
            display: grid;
            grid-template-columns: auto auto;
            gap: 20px;
            position: relative;
            padding-left: 2rem;
        }

        .footer-sub-blkk::before {
            content: "";
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            width: 1px;
            background-color: #ddd;
        }

        .footer-sub-blkk>* {
            padding-left: 1rem;
        }

        .footer-ul {
            list-style-type: none;
            padding-left: 0;
            text-align: justify;
        }

        .footer-ul-link {
            text-decoration: none;
            color: #C1ABAB;
            /* Default text color */
            display: block;
            padding: 0.5rem 0;
            /* Add padding for spacing */
            font-size: 15px;
            /* Font size for links */
            font-family: "Onest", Sans-serif;
        }

        .footer-ul-link:hover {
            color: #C1ABAB;
            /* Color on hover */
            transition: color 0.3s;
            /* Smooth color transition */
        }

        .footer-sub-blkk span:hover svg {
            fill: #C1ABAB;
            /* Change the SVG fill color on hover */
        }

        .footer-ul-link:hover {
            color: #fcb900;
            /* Color on hover */
            transition: color 0.3s;
            /* Smooth color transition */
        }

        .footer-copy {
            background-color: #581917;
            /* padding: 20px; */
            text-align: left;
            width: 100%;
            color: #C1ABAB;
            font-family: "Onest", Sans-serif;
            font-size: 16px;
            font-weight: 400;
            /* line-height: 0px; */
            /* margin-top: 22px; */
        }

        .e-font-icon-svg {
            width: 24px;
            height: 24px;
            fill: white;
        }

        .footer-copy p {
            padding-top: 1rem;
            padding-left: 2rem;
        }

        /* Add styles for footer01 */
        .footer01 {
            color: #FFFFFF;
            font-family: "Onest", Sans-serif;
            font-weight: 600;
            line-height: 35px;
            text-decoration: none;
        }

        .footer-sub-blkk a {
            display: inline-block;
            margin-right: 15px;
            /* Space between icons */
            color: #ffffff;
            /* Default icon color */
            transition: color 0.3s;
            /* Smooth color transition */
        }

        .footer-sub-blkk a:hover {
            color: #fcb900;
            /* Color on hover */
        }

        .e-font-icon-svg {
            width: 24px;
            height: 24px;
            fill: currentColor;
            /* Use current text color */
        }

        @media(max-width:600px) {
            .footer-sub-blkk::before {
                content: none;
            }

            .footer-sub-blkk {
                display: flex;
                justify-content: space-between;
                gap: 0px;
                padding-left: 0rem;
            }

            .footer-sub-blk>h6 {
                text-align: start;
                margin-bottom: 1rem;
            }

            .footer-sub-blkk>* {
                padding-left: 0rem;
            }
        }
    </style>
</head>

<body>

    <footer class="footer-main">
        <div class="footer-logo">
            <img src="https://www.nutralite.com/wp-content/uploads/2023/12/nutralite_logo.png" alt="Nutri.AI"
                style="max-width: 100%; height: auto;">
        </div>
        <div class="footer-blk">
            <div class="footer-sub-blk">
                <ul class="footer-ul">
                    <li><a href="https://www.nutralite.com/about-us/" class="footer01">About Us</a></li>
                    <li><a href="https://www.nutralite.com/blog" class="footer01">Blogs</a></li>
                    <li><a href="#" class="footer01">Contact Us</a></li>
                </ul>
            </div>
            <div class="footer-sub-blk">
                <ul class="footer-ul">
                    <li><a href="https://www.nutralite.com/recipes/" class="footer01">Products</a></li>
                    <li><a href="https://www.nutralite.com/nutralite-doodhshakti-product/"
                            class="footer-ul-link">Nutralite DoodhShakti</a></li>
                    <li><a href="https://www.nutralite.com/chocolate-spread/" class="footer-ul-link">Nutralite Choco
                            Spread</a></li>
                    <li><a href="https://www.nutralite.com/nutralite-mayonnaise-range/" class="footer-ul-link">Nutralite
                            Mayonnaise Range</a></li>
                    <li><a href="https://www.nutralite.com/table-spread/" class="footer-ul-link">Nutralite Table
                            Spread</a></li>
                    <li><a href="https://www.nutralite.com/professional/" class="footer-ul-link">Nutralite Yummy
                            Spread</a></li>
                    <li><a href="https://www.nutralite.com/professional/" class="footer-ul-link">Nutralite
                            Professional</a></li>
                </ul>
            </div>
            <div class="footer-sub-blk">
                <ul class="footer-ul">
                    <li><a href="https://www.nutralite.com/recipes/" class="footer01">Recipes</a></li>
                    <li><a href="#elementor-action%3Aaction%3Dpopup%3Aopen%26settings%3DeyJpZCI6IjI0NDkiLCJ0b2dnbGUiOmZhbHNlfQ%3D%3D"
                            class="footer-ul-link">Breakfast</a></li>
                    <li><a href="#elementor-action%3Aaction%3Dpopup%3Aopen%26settings%3DeyJpZCI6IjI0NDkiLCJ0b2dnbGUiOmZhbHNlfQ%3D%3D"
                            class="footer-ul-link">Desserts</a></li>
                    <li><a href="#" class="footer-ul-link">Kids Tiffin</a></li>
                    <li><a href="#" class="footer-ul-link">Lunch/Dinner</a></li>
                    <li><a href="#" class="footer-ul-link">Quick and Easy</a></li>
                </ul>
            </div>
            <div class="footer-sub-blk">
                <h6>Follow us on</h6>
                <div class="footer-sub-blkk">
                    <a href="https://www.instagram.com/yourprofile" target="_blank" aria-label="Instagram">
                        <svg class="e-font-icon-svg e-fab-instagram" viewBox="0 0 448 512">
                            <path
                                d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9 26.2 26.2 58 34.4 93.9 36.2 37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.9 0-184.9zm-48.5 223.8c-7.8 19.6-22.9 35.7-42.7 42.7-29.5 11.7-99.5 9-132.3 9s-102.7 2.6-132.3-9c-19.6-7.8-34.8-23.1-42.7-42.7-11.7-29.5-9-99.5-9-132.3s-2.6-102.7 9-132.3c7.8-19.6 22.9-35.7 42.7-42.7 29.5-11.7 99.5-9 132.3-9s102.7-2.6 132.3 9c19.6 7.8 34.8 23.1 42.7 42.7 11.7 29.5 9 99.5 9 132.3s2.6 102.7-9 132.3z">
                            </path>
                        </svg>
                    </a>
                    <a href="https://www.facebook.com/yourprofile" target="_blank" aria-label="Facebook">
                        <svg class="e-font-icon-svg e-fab-facebook-f" viewBox="0 0 320 512">
                            <path
                                d="M279.14 288l14.22-92.66h-88.91V141.41c0-25.35 12.42-50.06 52.24-50.06H293V6.26S273.05 0 248.12 0c-73.22 0-121.24 44.38-121.24 124.72v70.62H44.89V288h82v224h100.17V288z">
                            </path>
                        </svg>
                    </a>
                    <a href="https://www.youtube.com/yourchannel" target="_blank" aria-label="YouTube">
                        <svg class="e-font-icon-svg e-fab-youtube" viewBox="0 0 576 512">
                            <path
                                d="M549.65 124.11c-6.64-24.48-25.21-43.06-49.69-49.69C463.78 64 288 64 288 64S112.22 64 76.04 74.42C51.56 81.05 32.99 99.63 26.35 124.11 16 166.58 16 256 16 256s0 89.42 10.35 131.89c6.64 24.48 25.21 43.06 49.69 49.69C112.22 448 288 448 288 448s175.78 0 211.96-10.42c24.48-6.64 43.05-25.21 49.69-49.69C576 345.42 576 256 576 256s0-89.42-10.35-131.89zM233.32 346.41V165.59L343.4 256 233.32 346.41z">
                            </path>
                        </svg>
                    </a>
                    <a href="https://www.twitter.com/yourprofile" target="_blank" aria-label="Twitter">
                        <svg class="e-font-icon-svg e-fab-twitter" viewBox="0 0 512 512">
                            <path
                                d="M459.4 151.7c.32 4.54.32 9.09.32 13.63 0 138.72-105.58 298.55-298.55 298.55-59.5 0-114.68-17.22-161.11-47.106 8.447.97 16.568 1.284 25.34 1.284 49.055 0 94.213-16.568 130.274-44.832-46.132-.98-84.792-31.188-98.112-72.772 6.498.98 13.3 1.63 20.343 1.63 9.421 0 18.843-1.284 27.614-3.573-48.081-9.735-84.143-51.98-84.143-103.01v-1.284c14.182 7.89 30.361 12.67 47.431 13.3-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.63-7.789-2.599-15.924-2.599-24.058 0-57.897 46.782-104.934 104.934-104.934 30.361 0 57.897 12.67 77.2 33.137 24.058-4.548 46.781-13.63 67.034-25.965-7.888 24.706-24.706 45.515-46.456 58.792 21.367-2.274 41.692-8.215 60.426-16.568-14.292 20.791-32.361 39.308-53.024 54.253z">
                            </path>
                        </svg>
                    </a>
                </div>

            </div>
        </div>
    </footer>
    <div class="footer-copy">
        <p>Copyright © 2024 Nutralite | Privacy Policy | Terms & Conditions | Sitemap</p>
    </div>
</body>

</html>