@include('header')

   <style>
        @import url('https://fonts.googleapis.com/css2?family=Onest:wght@100..900&display=swap');

        @import url('https://fonts.googleapis.com/css2?family=Gupter:wght@400;500;700&family=Onest:wght@100..900&display=swap');

        body {
            font-family: "Onest", sans-serif;
        }

        .five-share-icons img {
            cursor: pointer;
        }

        .five-container {
            max-width: 900px;
            margin: auto;
        }

        .five-max-width {
            max-width: 900px;
            margin: auto;
            /* Center align the container */
        }

        .five-search-box {
            display: flex;
            align-items: center;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 5px;
            gap: 10px;
            background-color: #fff;
            margin-bottom: 20px;
            flex-wrap: nowrap;
            overflow: hidden;
            width: 600px;
            margin: auto;
        }

        .five-search-input {
            flex: 1;
            min-width: 0;
            padding: 8px;
            border: none;
            outline: none;
            box-sizing: border-box;
        }

        .five-search-actions {
            display: flex;
            gap: 5px;
        }

        .five-search-actions button {
            background: none;
            border: none;
            cursor: pointer;
            padding: 8px;
        }

        .five-search-actions img {
            width: 24px;
            height: 24px;
        }

        .five-filter-button {
            padding: 10px 15px;
            background-color: #000;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .five-content {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-top: 30px;
        }

        .five-image-placeholder {
            width: 100%;
            max-width: 200px;
            height: 200px;
            background-color: #ddd;
            border-radius: 10px;
            background-image: url('https://via.placeholder.com/200');
            background-size: cover;
            background-position: center;
        }

        .five-details {
            flex: 1;
        }

        .five-details h1 {
            font-size: 24px;
            margin: 0 0 10px;
            color: #471714;
        }

        .five-details p {
            margin: 0 0 20px;
            color: #471714;
            line-height: 1.6;
        }

        .five-nutrition {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            color: #471714;
        }

        .five-nutrition div {
            padding: 7px;
            border-radius: 5px;
            text-align: center;
            flex: 1;
            min-width: 100px;
        }

        .five-recipe-info .col {
            text-align: center;
            padding: 10px 0;
        }

        .five-recipe-info {
            margin-top: 20px;
            border-top: 1px solid #dee2e6;
            border-bottom: 1px solid #dee2e6;
            padding: 10px;
        }

        .five-recipe-info .col:last-child {
            border-right: none;
        }

        .five-container-main {
            margin-top: 20px;
            color: #471714;
        }

        .five-step {
            margin-top: 20px;
        }

        .five-share-icons {
            text-align: right;
        }

        .five-share-icons img {
            margin: 0 5px;
        }

        .five-logo {
            /* display: flex;
            align-items: center; */
            max-width: 900px;
            margin: auto;
            padding: 25px 10px;
            margin-top: 15x;
        }

        .five-logo a {
            display: flex;
            align-items: center;
        }

        .five-logo img {
            margin-right: 10px;
        }

        .faq-sec h2 {
            /* font-family: Frank Ruhl Libre; */
            font-family: "Onest", sans-serif;
            font-size: 60px;
            font-weight: 500;
            line-height: 66px;
            text-align: center;
        }

        .tab-content {
            width: 900px;
            margin: auto;
        }

        /* Custom Accordion Styles */
        .accordion-button {
            /* background-color: #EEECEC; */
            border: none;
            font-weight: bold;
            color: black;
            border-bottom: 1px solid #9D9D9D;
        }

        .accordion-button:focus {
            box-shadow: none;
        }

        .accordion-button:not(.collapsed) {
            color: #000;
            background-color: #d1d1d1;
        }

        .accordion-flush .accordion-item {
            border: none;
        }

        h2 .accordion-item {

            background-color: #f9f9f9;
            /* font-family: Inter; */
            font-family: "Onest", sans-serif;
            font-size: 24px;
            font-weight: 400;
            line-height: 26.4px;
            text-align: left;
        }

        .accordion-body {
            background-color: #f9f9f9;
            /* font-family: Inter; */
            font-family: "Onest", sans-serif;
            font-size: 18px;
            font-weight: 400;
            line-height: 26.4px;
            text-align: left;
        }


        @media (max-width: 600px) {
            .five-logo {
                padding: 20px;
            }

            .five-logo a {
                justify-content: center;
            }

            .five-logo span {
                font-size: 30px;
            }

            .five-container {
                padding: 12px;
            }

            .five-search-box {
                flex-direction: column;
                width: 100%;
            }

            .five-search-input {
                width: 100%;
                margin-bottom: 10px;
            }

            .five-content {
                flex-direction: column;
                margin-top: 0px;
                /* padding: 10px */
            }

            .five-image-placeholder {
                width: 100%;
                max-width: 100%;
                height: 100%;
            }

            .five-image-placeholder img {
                width: 100% !important;
                height: 100% !important;
            }

            .five-search-actions {
                justify-content: end;
                width: 100%;
            }

            .five-details h1 {
                font-size: 20px;
            }
        }

        footer {
            background-color: #471714;
            color: #fff;
            width: 100%;
            margin-top: 300px;
            padding: 11px 0px 90px 0px;
        }

        .footer-container {
            background-color: #FFFAE9;
            color: #000;
            border-radius: 10px;
            max-width: 1000px;
            margin: 0 auto;
            padding: 35px;
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            margin-top: -100px;
            border: 1px solid #000;
        }

        .footer-content {
            display: flex;
            flex-wrap: wrap;
            width: 100%;
            align-items: center;
            justify-content: space-between;
        }

        .footer-text {
            flex: 1;
            margin-right: 20px;
            min-width: 200px;
            /* font-family: Frank Ruhl Libre; */
            font-family: "Onest", sans-serif;
            font-size: 48px;
            font-weight: 500;
            line-height: 54.43px;
            text-align: left;
        }

        .footer-form {
            flex: 1;
            min-width: 200px;
        }

        .footer-form form {
            display: flex;
            flex-direction: column;
        }

        .footer-form input {
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
        }

        .footer-form button {
            padding: 12px;
            background-color: #000;
            color: #fff;
            border: none;
            border-radius: 50px;
            cursor: pointer;
            transition: background-color 0.3s ease;
            border: 1px solid #000;
        }

        .footer-form button:hover {
            background-color: #fff;
            color: #000;
            border: 1px solid #000;
        }

        .footer-placeholder {
            text-align: center;
            margin-top: 20px;
            font-size: 0.9em;
            color: #ccc;
        }


        @media (max-width: 600px) {
            .footer-content {
                flex-direction: column;
                align-items: flex-start;
            }

            .footer-text,
            .footer-form {
                min-width: 100%;
                margin: 0 0 10px 0;
            }

            .footer-text {
                text-align: center;
            }
        }

        #required-form-div {
            display: flex;
            align-items: center;
            justify-content: center;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            -webkit-backdrop-filter: blur(10px);
            backdrop-filter: blur(10px);
            box-shadow: 0 5px 50px rgba(0, 0, 0, 0.5);

        }
    </style>

<body>
    <!-- <div id="required-form-div">
        <div class="footer-container" style="margin-top:0;">
            <div class="footer-content">
                <div class="footer-form">
                    <h3 class="mb-3">Register Now</h3>
                    <form id="registration-form">
                        <input type="text" name="name" placeholder="Name" required>
                        <input type="text" id="contact" placeholder="Contact Number" name="contact" maxlength="10"
                            oninput="filterNonNumeric(this);" onblur="validateContact();">
                        <button type="submit" class="enq-submit"
                            style=" background: #B90101; border: none;">Submit</button>
                    </form>
                </div>
            </div>
        </div>
    </div> -->

    <!-- Script for form hide after button submit -->
    <!-- <script>
        $(document).ready(function () {
            $("#registration-form").submit(function (event) {
                event.preventDefault(); // Prevent the default form submission
                $("#required-form-div").css({ "display": "none" });
            });
        });
    </script> -->

    <!-- <nav class="five-logo">
        <a href="javascript:history.back()" style="text-decoration:none;">
            <img src="{{ asset('assets/images/nutri.ai.png') }}" alt="Icon" width="50">
            <span style="font-weight: 700;
    color: #471714;">Nutralite.AI</span>
        </a>
    </nav> -->
    <div class="five-container">
        <!-- <div class="five-search-box">
            <form action="{{ route('recipe2.generate') }}" method="POST" enctype="multipart/form-data"
                class="d-flex w-100">
                @csrf
                <input type="text" class="five-search-input" id="additional_instructions"
                    placeholder="Create a recipe for paneer butter masala..." name="additional_instructions">
                <div class="five-search-actions d-flex">
                    <button type="button"><img src="{{ asset('assets/images/share.png') }}" alt="Share"></button>
                    <button type="button"><img src="{{ asset('assets/images/copy-content.png') }}" alt="Copy"></button>
                    <button type="submit"><img src="{{ asset('assets/images/generate.png') }}" alt="Generate"></button>
                </div>
            </form>
        </div> -->
        <div class="five-content">
            <div class="five-image-placeholder mt-2">
                @if ($recipe['image'])
                    <img src="{{ $recipe['image'] }}" style="width: 200px; height: 200px;" alt="Recipe Image">
                @else
                    <p>No image available</p>
                @endif
            </div>
            <div class="five-details">
                <h1>{{ $recipe['recipe_title'] }}</h1>
                <p>{{ $recipe['recipe_description'] }}</p>
            </div>
        </div>
    </div>

    <div class="container five-max-width five-recipe-info">
        <div class="five-nutrition">
            <div>Recipe by:<strong>Nutralite</strong></div>
            <div>Cooking Time: <strong>{{ $recipe['cooking_time'] }} minutes</strong></div>
            <div>Preparation Time: <strong>{{ $recipe['preparation_time'] }} minutes</strong></div>
            <div>Servings: <strong>{{ $recipe['number_of_servings'] }}</strong></div>
        </div>
    </div>

    <div class="container five-max-width five-container-main">
        <div class="row">
            <div class="col-md-4">
                <h3>Ingredients</h3>
                <ul>
                    @foreach($recipe['ingredient_list'] as $value)
                        <li>{{ $value }}</li>
                    @endforeach
                </ul>
                <h3>Required Cookware:</h3>
                <ul>
                    @foreach($recipe['required_cookware'] as $item)
                        <li>{{ $item }}</li>
                    @endforeach
                </ul>
            </div>
            <div class="col-md-8">
                <h3>Steps</h3>
                @foreach($recipe['directions'] as $value)
                    <div class="five-step">
                        <h4>{{ $value['step_number'] }}. {{ $value['step_name'] }}</h4>
                        <p>{{ $value['instructions'] }}</p>
                    </div>
                @endforeach
            </div>
            <p class="fw-semibold">AI generated recipes may contain some inaccuracies*</p>
        </div>
    </div>

    <div class="container five-max-width">
        <hr>
        <div class="row five-share-icons">
            <div class="col-12">
                <span class="share-text">Share via:</span>
                <img src="{{ asset('assets/images/facebook.png') }}" alt="Facebook" onclick="shareRecipe('facebook')">
                <!-- <img src="{{ asset('assets/images/instagram.png') }}" alt="Instagram"
                    onclick="shareRecipe('instagram')"> -->
                <img src="{{ asset('assets/images/x.png') }}" alt="Twitter" onclick="shareRecipe('twitter')">
                <img src="{{ asset('assets/images/whatsapp.png') }}" alt="WhatsApp" onclick="shareRecipe('whatsapp')">
            </div>
        </div>
    </div>

    <!-- <div class="m-5 justify-content-center align-items-center faq-sec">
        <h2>Frequently Asked<br>Questions</h2>
    </div>
    <ul class="nav nav-pills mb-3 d-flex justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2 active" id="pills-home-tab" data-bs-toggle="pill"
                href="#general" role="tab" aria-controls="pills-home" aria-selected="true">General</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-profile-tab" data-bs-toggle="pill"
                href="#food" role="tab" aria-controls="pills-profile" aria-selected="false">Food</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-contact-tab" data-bs-toggle="pill"
                href="#ingredients" role="tab" aria-controls="pills-contact" aria-selected="false">Ingredients</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-recipes-tab" data-bs-toggle="pill"
                href="#recipes" role="tab" aria-controls="pills-recipes" aria-selected="false">Recipes</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-cooking-tab" data-bs-toggle="pill"
                href="#cooking" role="tab" aria-controls="pills-cooking" aria-selected="false">Cooking</a>
        </li>
    </ul>
    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="pills-home-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample1">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
                            1. How much coffee is too much coffee?
                        </button>
                    </h2>
                    <div id="flush-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            2. How do I choose the right diet plan?
                        </button>
                    </h2>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo"
                        data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThree" aria-expanded="false" aria-controls="flush-collapseThree">
                            3. What are some good sources of protein for vegetarians?
                        </button>
                    </h2>
                    <div id="flush-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="food" role="tabpanel" aria-labelledby="pills-profile-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample2">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFour" aria-expanded="true" aria-controls="flush-collapseFour">
                            1. What are the benefits of a Mediterranean diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFive" aria-expanded="false" aria-controls="flush-collapseFive">
                            2. How can I reduce sugar in my diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSix" aria-expanded="false" aria-controls="flush-collapseSix">
                            3. What are some healthy snacks for weight loss?
                        </button>
                    </h2>
                    <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="ingredients" role="tabpanel" aria-labelledby="pills-contact-tab">
            Ingredients content.
        </div>
        <div class="tab-pane fade" id="recipes" role="tabpanel" aria-labelledby="pills-recipes-tab">
            Recipes content.
        </div>
        <div class="tab-pane fade" id="cooking" role="tabpanel" aria-labelledby="pills-cooking-tab">
            Cooking content.
        </div>
    </div> -->

    <!-- <footer>
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-text">
                    Join our Community to receive tastier and healthier recipes
                </div>
                <div class="footer-form">
                    <form>
                        <input type="text" name="name" placeholder="Name" required>
                        <input type="text" id="contact" placeholder="Contact Number" name="contact" maxlength="10"
                            oninput="filterNonNumeric(this);" onblur="validateContact();">
                        <button type="submit" style=" background: #B90101; border: none;">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="footer-placeholder">
            PLACEHOLDER FOR FOOTER
        </div>
    </footer> -->

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
    <script>
        function shareRecipe(platform) {
            const recipeTitle = "{{ $recipe['recipe_title'] }}";
            const recipeImage = "{{ $recipe['image'] }}";
            const recipeLink = encodeURIComponent(window.location.href); // Ensure the URL is encoded properly
            const recipeDescription = "{{ $recipe['recipe_description'] }}";
            const cookingTime = "{{ $recipe['cooking_time'] }}";
            const preparationTime = "{{ $recipe['preparation_time'] }}";
            const numberOfServings = "{{ $recipe['number_of_servings'] }}";

            let ingredientList = '';
            @foreach($recipe['ingredient_list'] as $value)
                ingredientList += "{{ $value }}\n";
            @endforeach

            let cookwareList = '';
            @foreach($recipe['required_cookware'] as $item)
                cookwareList += "{{ $item }}\n";
            @endforeach

            let directionsList = '';
            @foreach($recipe['directions'] as $value)
                directionsList += "{{ $value['step_number'] }}. {{ $value['step_name'] }}: {{ $value['instructions'] }}\n";
            @endforeach

            const additionalText = "I've tried Nutralite.Ai for making an easy and quick recipe. Do check out here: https://nutralite.com/nutralite-ai";

            let shareText = `${additionalText}\n\nRecipe Title: ${recipeTitle}\n\nDescription: ${recipeDescription}\n\nCooking Time: ${cookingTime} minutes\nPreparation Time: ${preparationTime} minutes\nServings: ${numberOfServings}\n\nIngredients:\n${ingredientList}\nCookware:\n${cookwareList}\n\nDirections:\n${directionsList}\n\nLink: ${decodeURIComponent(recipeLink)}`;

            if (platform === 'facebook') {
                window.open(`https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(recipeLink)}&quote=${encodeURIComponent(additionalText)}`, '_blank');
            } else if (platform === 'instagram') {
                alert('Instagram sharing is not supported via web.');
            } else if (platform === 'twitter') {
                window.open(`https://twitter.com/intent/tweet?text=${encodeURIComponent(additionalText)}`, '_blank');
            } else if (platform === 'whatsapp') {
                window.open(`https://wa.me/?text=${encodeURIComponent(additionalText)}`, '_blank');
            }
        }
    </script>

</body>
@include('footer')

</html>