<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Responsive Design</title>
    <!-- <link rel="stylesheet" href="style.css"> -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300..900&display=swap" rel="stylesheet">
    <meta property="og:title" content="<?php echo e($recipe['recipe_title']); ?>">
    <meta property="og:description" content="<?php echo e($recipe['recipe_description']); ?>">
    <meta property="og:image" content="<?php echo e($recipe['image']); ?>">
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($recipe['recipe_title']); ?>">
    <meta name="twitter:description" content="<?php echo e($recipe['recipe_description']); ?>">
    <meta name="twitter:image" content="<?php echo e($recipe['image']); ?>">
    <style>
        .five-share-icons img {
            cursor: pointer;
        }
        .five-container {
            max-width: 900px;
            margin: auto;
        }

        .five-max-width {
            max-width: 900px;
            margin: auto;
            /* Center align the container */
        }

        .five-search-box {
            display: flex;
            align-items: center;
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 5px;
            gap: 10px;
            background-color: #fff;
            margin-bottom: 20px;
            flex-wrap: nowrap;
            overflow: hidden;
            width: 600px;
            margin: auto;
        }

        .five-search-input {
            flex: 1;
            min-width: 0;
            padding: 8px;
            border: none;
            outline: none;
            box-sizing: border-box;
        }

        .five-search-actions {
            display: flex;
            gap: 5px;
        }

        .five-search-actions button {
            background: none;
            border: none;
            cursor: pointer;
            padding: 8px;
        }

        .five-search-actions img {
            width: 24px;
            height: 24px;
        }

        .five-filter-button {
            padding: 10px 15px;
            background-color: #000;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .five-content {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
            margin-top: 30px;
        }

        .five-image-placeholder {
            width: 100%;
            max-width: 200px;
            height: 200px;
            background-color: #ddd;
            border-radius: 10px;
            background-image: url('https://via.placeholder.com/200');
            background-size: cover;
            background-position: center;
        }

        .five-details {
            flex: 1;
        }

        .five-details h1 {
            font-size: 24px;
            margin: 0 0 10px;
            color: #471714;
        }

        .five-details p {
            margin: 0 0 20px;
            color: #471714;
            line-height: 1.6;
        }

        .five-nutrition {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
            color: #471714;
        }

        .five-nutrition div {
            padding: 7px;
            border-radius: 5px;
            text-align: center;
            flex: 1;
            min-width: 100px;
        }

        .five-recipe-info .col {
            text-align: center;
            padding: 10px 0;
        }

        .five-recipe-info {
            margin-top: 20px;
            border-top: 1px solid #dee2e6;
            border-bottom: 1px solid #dee2e6;
            padding: 10px;
        }

        .five-recipe-info .col:last-child {
            border-right: none;
        }

        .five-container-main {
            margin-top: 20px;
            color: #471714;
        }

        .five-step {
            margin-top: 20px;
        }

        .five-share-icons {
            text-align: right;
        }

        .five-share-icons img {
            margin: 0 5px;
        }

        .five-logo {
            display: flex;
            align-items: center;
            max-width: 900px;
            margin: auto;
            margin-top: 15x;
        }

        .five-logo img {
            margin-right: 10px;
        }

        .faq-sec h2 {
    font-family: Frank Ruhl Libre;
    font-size: 60px;
    font-weight: 500;
    line-height: 66px;
    text-align: center;
}

.tab-content{width: 900px;
    margin: auto;}

/* Custom Accordion Styles */
.accordion-button {
    /* background-color: #EEECEC; */
    border: none;
    font-weight: bold;
    color: black;
    border-bottom: 1px solid #9D9D9D;
}

.accordion-button:focus {
    box-shadow: none;
}

.accordion-button:not(.collapsed) {
    color: #000;
    background-color: #d1d1d1;
}

.accordion-flush .accordion-item {
    border: none;
}

h2 .accordion-item {

    background-color: #f9f9f9;
    font-family: Inter;
  font-size: 24px;
  font-weight: 400;
  line-height: 26.4px;
  text-align: left;
}

.accordion-body {
    background-color: #f9f9f9;
    font-family: Inter;
  font-size: 18px;
  font-weight: 400;
  line-height: 26.4px;
  text-align: left;
}


        @media (max-width: 600px) {
            .five-search-box {
                flex-direction: column;
            }

            .five-search-input {
                width: 100%;
                margin-bottom: 10px;
            }

            .five-search-actions {
                justify-content: center;
                width: 100%;
            }

            .five-details h1 {
                font-size: 20px;
            }
        }

footer {
    background-color: #471714;
    color: #fff;
    width: 100%;
    margin-top: 300px;
    padding: 11px 0px 90px 0px;
}

.footer-container {
    background-color: #FFFAE9;
    color: #000;
    border-radius: 10px;
    max-width: 1000px;
    margin: 0 auto;
    padding: 35px;
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    justify-content: space-between;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
    margin-top: -100px;
    border: 1px solid #000;
}

.footer-content {
    display: flex;
    flex-wrap: wrap;
    width: 100%;
    align-items: center;
    justify-content: space-between;
}

.footer-text {
    flex: 1;
    margin-right: 20px;
    min-width: 200px;
    font-family: Frank Ruhl Libre;
    font-size: 48px;
    font-weight: 500;
    line-height: 54.43px;
    text-align: left;
}

.footer-form {
    flex: 1;
    min-width: 200px;
}

.footer-form form {
    display: flex;
    flex-direction: column;
}

.footer-form input {
    padding: 10px;
    margin-bottom: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
}

.footer-form button {
    padding: 12px;
    background-color: #000;
    color: #fff;
    border: none;
    border-radius: 50px;
    cursor: pointer;
    transition: background-color 0.3s ease;
    border: 1px solid #000;
}

.footer-form button:hover {
    background-color: #fff;
    color: #000;
    border: 1px solid #000;
}

.footer-placeholder {
    text-align: center;
    margin-top: 20px;
    font-size: 0.9em;
    color: #ccc;
}


@media (max-width: 600px) {
    .footer-content {
        flex-direction: column;
        align-items: flex-start;
    }

    .footer-text, .footer-form {
        min-width: 100%;
        margin: 0 0 10px 0;
    }

    .footer-text {
        text-align: center;
    }
}
    </style>
</head>
<body>
    <nav class="five-logo">
        <img src="<?php echo e(asset('assets/images/nutri.ai.png')); ?>" alt="Icon" width="50">
        <span style="font-weight: 700;
    color: #471714;">Nutri.AI</span>
    </nav>
    <div class="five-container">
    <div class="five-search-box">
    <form action="<?php echo e(route('recipe2.generate')); ?>" method="POST" enctype="multipart/form-data" class="d-flex w-100">
        <?php echo csrf_field(); ?>
        <input type="text" class="five-search-input" id="additional_instructions"
               placeholder="Create a recipe for paneer butter masala..." name="additional_instructions">
        <div class="five-search-actions d-flex">
            <button type="button"><img src="<?php echo e(asset('assets/images/share.png')); ?>" alt="Share"></button>
            <button type="button"><img src="<?php echo e(asset('assets/images/copy-content.png')); ?>" alt="Copy"></button>
            <button type="submit"><img src="<?php echo e(asset('assets/images/generate.png')); ?>" alt="Generate"></button>
        </div>
    </form>
</div>
        <div class="five-content">
            <div class="five-image-placeholder mt-2">
                <?php if($recipe['image']): ?>
                    <img src="<?php echo e($recipe['image']); ?>" style="width: 200px; height: 200px;" alt="Recipe Image">
                <?php else: ?>
                    <p>No image available</p>
                <?php endif; ?>
            </div>
            <div class="five-details">
                <h1><?php echo e($recipe['recipe_title']); ?></h1>
                <p><?php echo e($recipe['recipe_description']); ?></p>
            </div>
        </div>
    </div>

    <div class="container five-max-width five-recipe-info">
        <div class="five-nutrition">
            <div>Recipe by:<strong>Nutralite</strong></div>
            <div>Cooking Time: <strong><?php echo e($recipe['cooking_time']); ?> minutes</strong></div>
            <div>Preparation Time: <strong><?php echo e($recipe['preparation_time']); ?> minutes</strong></div>
            <div>Servings: <strong><?php echo e($recipe['number_of_servings']); ?></strong></div>
        </div>
    </div>

    <div class="container five-max-width five-container-main">
        <div class="row">
            <div class="col-md-4">
                <h3>Ingredients</h3>
                <ul>
                    <?php $__currentLoopData = $recipe['ingredient_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($value); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <h3>Required Cookware:</h3>
                <ul>
                    <?php $__currentLoopData = $recipe['required_cookware']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($item); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
            <div class="col-md-8">
                <h3>Steps</h3>
                <?php $__currentLoopData = $recipe['directions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="five-step">
                        <h4><?php echo e($value['step_number']); ?>. <?php echo e($value['step_name']); ?></h4>
                        <p><?php echo e($value['instructions']); ?></p>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="container five-max-width">
        <hr>
        <div class="row five-share-icons">
            <div class="col-12">
                <span class="share-text">Share via:</span>
                <img src="<?php echo e(asset('assets/images/facebook.png')); ?>" alt="Facebook" onclick="shareRecipe('facebook')">
                <img src="<?php echo e(asset('assets/images/instagram.png')); ?>" alt="Instagram" onclick="shareRecipe('instagram')">
                <img src="<?php echo e(asset('assets/images/x.png')); ?>" alt="Twitter" onclick="shareRecipe('twitter')">
                <img src="<?php echo e(asset('assets/images/whatsapp.png')); ?>" alt="WhatsApp" onclick="shareRecipe('whatsapp')">
            </div>
        </div>
    </div>

    <!-- <div class="m-5 justify-content-center align-items-center faq-sec">
        <h2>Frequently Asked<br>Questions</h2>
    </div>
    <ul class="nav nav-pills mb-3 d-flex justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2 active" id="pills-home-tab" data-bs-toggle="pill"
                href="#general" role="tab" aria-controls="pills-home" aria-selected="true">General</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-profile-tab" data-bs-toggle="pill"
                href="#food" role="tab" aria-controls="pills-profile" aria-selected="false">Food</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-contact-tab" data-bs-toggle="pill"
                href="#ingredients" role="tab" aria-controls="pills-contact" aria-selected="false">Ingredients</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-recipes-tab" data-bs-toggle="pill"
                href="#recipes" role="tab" aria-controls="pills-recipes" aria-selected="false">Recipes</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-cooking-tab" data-bs-toggle="pill"
                href="#cooking" role="tab" aria-controls="pills-cooking" aria-selected="false">Cooking</a>
        </li>
    </ul>
    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="pills-home-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample1">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
                            1. How much coffee is too much coffee?
                        </button>
                    </h2>
                    <div id="flush-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            2. How do I choose the right diet plan?
                        </button>
                    </h2>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo"
                        data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThree" aria-expanded="false" aria-controls="flush-collapseThree">
                            3. What are some good sources of protein for vegetarians?
                        </button>
                    </h2>
                    <div id="flush-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="food" role="tabpanel" aria-labelledby="pills-profile-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample2">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFour" aria-expanded="true" aria-controls="flush-collapseFour">
                            1. What are the benefits of a Mediterranean diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFive" aria-expanded="false" aria-controls="flush-collapseFive">
                            2. How can I reduce sugar in my diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSix" aria-expanded="false" aria-controls="flush-collapseSix">
                            3. What are some healthy snacks for weight loss?
                        </button>
                    </h2>
                    <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="ingredients" role="tabpanel" aria-labelledby="pills-contact-tab">
            Ingredients content.
        </div>
        <div class="tab-pane fade" id="recipes" role="tabpanel" aria-labelledby="pills-recipes-tab">
            Recipes content.
        </div>
        <div class="tab-pane fade" id="cooking" role="tabpanel" aria-labelledby="pills-cooking-tab">
            Cooking content.
        </div>
    </div> -->

    <footer>
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-text">
                    Join our Community to receive tastier and healthier recipes
                </div>
                <div class="footer-form">
                    <form>
                        <input type="text" name="name" placeholder="Name" required>
                        <input type="text" id="contact" placeholder="Contact Number" name="contact" maxlength="10"
                            oninput="filterNonNumeric(this);" onblur="validateContact();">
                        <button type="submit" style=" background: #B90101; border: none;">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="footer-placeholder">
            PLACEHOLDER FOR FOOTER
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.6/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
    <script>
        function shareRecipe(platform) {
            const recipeTitle = "<?php echo e($recipe['recipe_title']); ?>";
            const recipeImage = "<?php echo e($recipe['image']); ?>";
            const recipeLink = encodeURIComponent(window.location.href); // Ensure the URL is encoded properly
            const recipeDescription = "<?php echo e($recipe['recipe_description']); ?>";
            const cookingTime = "<?php echo e($recipe['cooking_time']); ?>";
            const preparationTime = "<?php echo e($recipe['preparation_time']); ?>";
            const numberOfServings = "<?php echo e($recipe['number_of_servings']); ?>";

            let ingredientList = '';
            <?php $__currentLoopData = $recipe['ingredient_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                ingredientList += "<?php echo e($value); ?>\n";
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            let cookwareList = '';
            <?php $__currentLoopData = $recipe['required_cookware']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                cookwareList += "<?php echo e($item); ?>\n";
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            let directionsList = '';
            <?php $__currentLoopData = $recipe['directions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                directionsList += "<?php echo e($value['step_number']); ?>. <?php echo e($value['step_name']); ?>: <?php echo e($value['instructions']); ?>\n";
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            let shareText = `Recipe Title: ${recipeTitle}\n\nDescription: ${recipeDescription}\n\nCooking Time: ${cookingTime} minutes\nPreparation Time: ${preparationTime} minutes\nServings: ${numberOfServings}\n\nIngredients:\n${ingredientList}\nCookware:\n${cookwareList}\n\nDirections:\n${directionsList}\n\nLink: ${decodeURIComponent(recipeLink)}`;

            if (platform === 'facebook') {
                window.open(`https://www.facebook.com/sharer/sharer.php?u=${recipeLink}`, '_blank');
            } else if (platform === 'instagram') {
                alert('Instagram sharing is not supported via web.');
            } else if (platform === 'twitter') {
                window.open(`https://twitter.com/intent/tweet?text=${encodeURIComponent(shareText)}&url=${recipeLink}`, '_blank');
            } else if (platform === 'whatsapp') {
                window.open(`https://wa.me/?text=${encodeURIComponent(shareText)}`, '_blank');
            }
        }
    </script>
</body>


</html>
<?php /**PATH C:\xampp\htdocs\cooking-recipe\resources\views/recipe-generator.blade.php ENDPATH**/ ?>