<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class Recipe2Controller extends Controller
{
    public function showFormdata()
    {
        return view('recipe2');
    }

    public function generateRecipe(Request $request)
    {
        $request->validate([
            'ingredients' => 'nullable|string',
            'cuisine' => 'nullable|in:North Indian,South Indian,Gujarati,Bengali,Maharashtrian,Goan,Italian,Mexican,Chinese,Thai',
            'meal_type' => 'nullable|in:Breakfast,Lunch,Dinner,Snack,Dessert',
            'difficulty' => 'nullable|in:Beginner,Intermediate,Advanced',
            'cooking_time' => 'nullable|in:Under 30 minutes,30-60 minutes,60–90 minutes,Over 90 minutes',
            'dietary_restrictions' => 'nullable|array',
            'dietary_restrictions.*' => 'in:Vegetarian,Gluten-free,Diabetic-friendly,Low-calorie,High-protein',
            'servings' => 'nullable|integer|min:4',
            'veg_nonveg' => 'nullable|in:Veg,Non-Veg',
            'additional_instructions' => 'nullable|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', 
        ]);


        $apiKey = env('API_KEY');
        $workflow = env('WORKFLOW_ID');

        $additional_instructions = $request->input('additional_instructions', '');
        $veg_nonveg = $request->input('veg_only', '');
        $ingredients = $request->input('ingredients', '');
        $meal_type = $request->input('meal_type', '');
        $cuisine = $request->input('cuisine', '');

        $additional_info = [];
if ($veg_nonveg) {
    $additional_info[] = $veg_nonveg;
}
if ($ingredients) {
    $additional_info[] = "Ingredients: $ingredients";
}
if ($meal_type) {
    $additional_info[] = "Meal Type: $meal_type";
}
if ($cuisine) {
    $additional_info[] = "Cuisine: $cuisine";
}

// Combine all additional information
$additional_instructions .= ($additional_instructions ? ', ' : '') . implode(', ', $additional_info);

if ($request->hasFile('image')) {
    $image = $request->file('image');
    $imagePath = $image->store('recipe_images', 'public');
} else {
    $imagePath = '';
}

        $data = [
            'workflow' => $workflow,
            'input' => [
                'ingredients' => array_map('trim', explode(',', $request->input('ingredients', ''))),
                'cuisine' => $request->input('cuisine', ''),
                'meal_type' => $request->input('meal_type', ''),
                'difficulty' => $request->input('difficulty', 'Beginner'),
                'cooking_time' => $request->input('cooking_time', 'Under 30 minutes'),
                'dietary_restrictions' => $request->input('dietary_restrictions', []),
                'servings' => (int) $request->input('servings', 1),
                'additional_instructions' => $additional_instructions,
                'image' => $imagePath,
            ],
        ];

        Log::info('Request Data:', $data);

        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            'apiKey' => $apiKey,
        ])->timeout(120) // Set the timeout to 120 seconds
          ->post('https://hub.peppercontent.io/workflows/v1/run', $data);
        Log::info('Response Status: ' . $response->status());
        Log::info('Response Body: ' . $response->body());

        if ($response->successful()) {
            $recipe = json_decode($response->json()['output'], true);
            
            return view('recipe-generator', compact('recipe'));

            
        } else {
            return back()->withErrors(['msg' => 'Failed to fetch the recipe. Please try again later.']);
        }
    }
}
