<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nutralite.AI - Create a recipe</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300..900&display=swap" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

</head>

<body>


    <div class="web_banner">

        <picture>
            <source media="(min-width: 650px)" srcset="{{ asset('assets/images/Website_Banner.png') }}">
            <source media="(min-width: 465px)" srcset="{{ asset('assets/images/Nutralite_Receipe_Mobile.png') }}">
            <!-- img tag for browsers that do not support picture element -->
            <img src="{{ asset('assets/images/Nutralite_Receipe_Mobile.png') }}" alt="">
        </picture>

    </div>


    <div class="new_box">

        <!-- <nav>
            <div class="logo">
                <img src="{{ asset('assets/images/nutri.ai.png') }}" alt="Icon">
                <span>Nutri.AI</span>
            </div>
        </nav> -->
        <!-- <hr style="border-top: 1px solid #000;margin: 10px 0;width: 80%;"> -->
        <div class="prev-button">
            <!-- <img src="{{ asset('assets/images/back-to.png') }}" alt="back-to"> -->
            <!-- <button class="uniq-pre">Previous</button> -->
        </div>

        <!-- <div class="m-3 d-flex justify-content-center">
            <h1 class="main-title w-md-75">
                Craft Culinary Delights with AI: <br> Explore Endless Recipe Possibilities
            </h1>
        </div> -->

        <!-- <div class="col-2">
    <label class="switch">
        <input type="checkbox" id="vegToggle" onchange="toggleVegNonVeg()">
        <span class="slider round"></span>
    </label>
    <div id="toggle-label" class="toggle-label">Vegetarian</div>
</div> -->





        <div class="card rcard">
            <div style="max-width: 700px; width: 100%;">
                <form action="{{ route('recipe2.generate') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="d-flex justify-content-end align-items-center">
                        <div class="toggle-container">
                            <label class="switch">
                                <input type="checkbox" id="toggle" onchange="toggleLabel()" name="veg_only">
                                <span class="slider round"></span>
                            </label>
                            <span id="toggle-label" class="toggle-label">Veg Only</span>
                        </div>
                    </div>

                    <div class="search-box" style="padding: 3px; max-width: 1000px; margin: 10px 0; padding: 10px">
                        <i class="fa fa-search"></i>
                        <input type="text" class="form-control no-outline" id="additional_instructions"
                            placeholder="What shall we cook up today?" name="additional_instructions"
                            style="width: calc(100% - 40px); margin-right: 5px;">
                        <button id="micBtn" style="border: none; background: transparent; cursor: pointer;">
                            <img src="{{ asset('assets/images/mic-phone.png') }}" alt="Mic"
                                style="width: 24px; height: 24px;">
                        </button>
                        <button type="button" onclick="document.getElementById('imageInput').click()"
                            style="border: none; background: transparent; cursor: pointer;">
                            <img src="{{ asset('assets/images/upload-image.png') }}" alt="upload-image"
                                style="width: 24px; height: 24px;">
                        </button>
                        <input type="file" id="imageInput" accept="image/*" name="image" style="display: none;">
                    </div>

                    <div class="form-group row mt-4">
                        <label for="ingredientsList" class="col-1 col-form-label text-end">
                            <div class="dot">1</div>
                        </label>
                        <div class="col-11">
                            <input type="text" class="form-control" id="ingredientsList"
                                placeholder="Search or add ingredients" name="ingredients">
                            <p><strong>Most commonly used ingredients:</strong> (Select from the list to add
                                ingredients)</p>
                            <div id="ingredientButtons">
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Chicken">Chicken <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Tomato Puree">Tomato Puree <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Green Chillies">Green Chillies <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Turmeric Powder">Turmeric Powder <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Fresh Cream">Fresh Cream <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Ginger-Garlic Paste">Ginger-Garlic Paste <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Besan">Besan <span class="badge" style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Pure Ghee">Pure Ghee <span class="badge"
                                        style="color: red;"></span></button>
                                <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                                    data-value="Butter">Butter <span class="badge" style="color: red;"></span></button>
                            </div>
                        </div>
                    </div>

                    <div class="form-group row mt-4">
                        <label for="meal_type" class="col-1 col-form-label text-end">
                            <div class="dot">2</div>
                        </label>
                        <div class="col-5">
                            <select class="form-control" id="mealtype" name="meal_type">
                                <option value="">Select your meal</option>
                                <option value="Breakfast">Breakfast</option>
                                <option value="Lunch">Lunch</option>
                                <option value="Dinner">Dinner</option>
                                <option value="Snack">Snack</option>
                                <option value="Dessert">Dessert</option>
                            </select>
                        </div>
                        <label for="cuisine" class="col-1 col-form-label text-end">
                            <div class="dot">3</div>
                        </label>
                        <div class="col-5">
                            <select class="form-control" id="cuisine" name="cuisine">
                                <option value="">Select your cuisine</option>
                                <option value="North Indian">North Indian</option>
                                <option value="South Indian">South Indian</option>
                                <option value="Gujarati">Gujarati</option>
                                <option value="Bengali">Bengali</option>
                                <option value="Maharashtrian">Maharashtrian</option>
                                <option value="Goan">Goan</option>
                                <option value="Italian">Italian</option>
                                <option value="Mexican">Mexican</option>
                                <option value="Chinese">Chinese</option>
                                <option value="Thai">Thai</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-12" style="padding-top: 2rem;">
                        <button type="submit" id="generateButton" class="btn btn-dark btn-lg btn-block load">Generate
                            Recipe</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- Preloader code start -->
        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js"></script>

        <script>
            $(document).ready(function () {
                $(".load").click(function () {
                    $("#processing").css({ "display": "block" });
                });
            });
        </script>

        <!-- Script for hitting enter when search input typed start -->
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var searchInput = document.getElementById('additional_instructions');
                var form = searchInput.closest('form');

                searchInput.addEventListener('keypress', function (event) {
                    if (event.key === 'Enter') {
                        event.preventDefault(); // Prevent the default action of the Enter key
                        document.getElementById('generateButton').click(); // Simulate a click on the submit button
                    }
                });
            });
        </script>

        <!-- Script for hitting enter when search input typed end -->

        <div id="processing"
            style="display:none;-webkit-backdrop-filter: blur(10px);
    backdrop-filter: blur(4px);
    box-shadow: 0 5px 50px rgba(0, 0, 0, 0.5);height:100%;width:100%;position:fixed;top:0;left:0;bottom:0;right:0;z-index:99999;">
            <span
                style="display:flex;flex-direction:column;justify-content:center;align-items:center;height:100%;margin:auto;top:0;bottom:0;left:0;right:0;">
                <h3 style="margin:0px;text-align:center; ">Your recipe is getting generated...</h3><img
                    style="max-width:300px;" src="{{ asset('assets/images/cooking-image.gif') }}"></img>
            </span>
        </div>
        <!-- Preloader code end -->

        <BR>
        OR
        <div class="ai-suggestion ms-3">
            <form action="{{ route('recipe2.generate') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <button class="load" onclick="suggestRecipe()" style="border-radius: 10px;">
                    <img src="{{ asset('assets/images/get-ai-to-suggest-you-a-recipe.png') }}"
                        alt="get-ai-to-suggest-you-a-recipe" style="width: 30px; height: 30px; ">
                    Surpise Me with a recipe →
                </button>
        </div>


        <div id="loginModal" class="modal">
            <div class="modal-content">
                <span class="close">&times;</span>
                <h2 class="pop-head">Enter Your Details</h2>
                <form id="loginForm" class="pop-ip">
                    <input type="text" id="name" name="name" placeholder="Full Name"><br>
                    <input type="email" id="email" name="email" placeholder="Email"><br>
                    <input type="tel" id="mobile" name="mobile" placeholder="Mobile"><br>
                    <button type="submit" id="googleLogin">Submit</button>
                </form>
            </div>
        </div>


    </div>


    <!--  -->

    <div class="justify-content-center align-items-center faq-sec">
        <h2>Frequently Asked<br>Questions</h2>
    </div>
    <ul class="nav nav-pills mb-3 d-flex justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2 active" id="pills-home-tab" data-bs-toggle="pill"
                href="#general" role="tab" aria-controls="pills-home" aria-selected="true">General</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-profile-tab" data-bs-toggle="pill"
                href="#food" role="tab" aria-controls="pills-profile" aria-selected="false">Food</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-contact-tab" data-bs-toggle="pill"
                href="#ingredients" role="tab" aria-controls="pills-contact" aria-selected="false">Ingredients</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-recipes-tab" data-bs-toggle="pill"
                href="#recipes" role="tab" aria-controls="pills-recipes" aria-selected="false">Recipes</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-cooking-tab" data-bs-toggle="pill"
                href="#cooking" role="tab" aria-controls="pills-cooking" aria-selected="false">Cooking</a>
        </li>
    </ul>




    <div class="tab-content" id="pills-tabContent">


        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="pills-home-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample1">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
                            1. What is Nutri AI?
                        </button>
                    </h2>
                    <div id="flush-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body"> Nutra AI is a generative AI recipe generator that creates
                            personalized recipes based on a list of ingredients, cuisine preferences, and dietary needs.
                            It also suggests meal plans for the day.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            2. What is Nutralite?
                        </button>
                    </h2>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo"
                        data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body"> Nutralite products are designed to enhance the flavours of dishes
                            universally, catering to everyone, everywhere. Our intention is simple: to be the go-to
                            choice for anyone seeking to enhance the taste of their meals but also wanting to make
                            healthier choices. Check more about the products here - <a
                                href="https://www.nutralite.com/products/"> www.nutralite.com/products </a> </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThree" aria-expanded="false"
                            aria-controls="flush-collapseThree">
                            3. Can Nutralite be used for baking and cooking?
                        </button>
                    </h2>
                    <div id="flush-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body"> Yes. Both Nutralite Table Spread and the Nutralite DoodhShakti can
                            be used for cooking and baking. </div>
                    </div>
                </div>

                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFour" aria-expanded="false"
                            aria-controls="flush-collapseFour">
                            4. How do Nutralite products contribute to a healthier lifestyle?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse" aria-labelledby="flush-headingFour"
                        data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body"> There are different types of Nutralite products, each with
                            properties that help you make healthier choices. Nutralite DoodhShakti Probiotic Butter
                            Spread helps boost immunity. Nutralite DoodShakti Pure Ghee, sourced from the land of Braj,
                            is also enriched with Vitamin A. The Nutralite Table Spread range is naturally
                            cholesterol-free and is enriched with omega 3, whereas the Mayonnaise spread range is rich
                            in vitamins A, D, and E. Each of the products comes with benefits; pick what you need and
                            embrace a balanced life! </div>
                    </div>
                </div>


            </div>
        </div>


        <!--  -->



        <div class="tab-pane fade" id="food" role="tabpanel" aria-labelledby="pills-profile-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample2">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFour" aria-expanded="true"
                            aria-controls="flush-collapseFour">
                            1. What should an ideal diet contain?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">
                            An ideal diet should include: <br>
                            Carbohydrates: Whole grains, fruits, vegetables. <br>
                            Proteins: Lean meats, fish, eggs, legumes, nuts.<br>
                            Fats: Healthy fats from avocados, nuts, seeds, olive oil, fatty fish.<br>
                            Vitamins and Minerals: A variety of fruits, vegetables, whole grains, dairy, and lean
                            proteins.

                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFive" aria-expanded="false"
                            aria-controls="flush-collapseFive">
                            2. Does indian food use plant-based ingredients?
                        </button>
                    </h2>
                    <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body"> Indian cuisine incorporates various plant-based ingredients such as
                            lentils, legumes, vegetables, whole grains, and spices. These ingredients are rich in fiber,
                            vitamins, minerals, and antioxidants, which are essential for maintaining good health.
                            Plant-based diets have been associated with various health benefits, including reduced risk
                            of heart disease, diabetes, and certain cancers. </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSix" aria-expanded="false" aria-controls="flush-collapseSix">
                            3. How do I prevent my baked goods from sticking to the pan?
                        </button>
                    </h2>
                    <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body"> Grease the pan with butter, oil, or cooking spray.
                            Line the pan with parchment paper.
                            Use non-stick baking pans.
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!-- NEW Below -->


        <div class="tab-pane fade" id="ingredients" role="tabpanel" aria-labelledby="pills-contact-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample3">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSeven">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSeven" aria-expanded="true"
                            aria-controls="flush-collapseSeven">
                            1. What are natural ingredients?
                        </button>
                    </h2>
                    <div id="flush-collapseSeven" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingSeven" data-bs-parent="#accordionFlushExample3">
                        <div class="accordion-body">
                            Natural ingredients are derived from natural sources such as plants, minerals, and animals.
                            They undergo minimal processing and are often used in their raw form to retain their natural
                            benefits.
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingEight">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseEight" aria-expanded="false"
                            aria-controls="flush-collapseEight">
                            2. What is the difference between organic and non-organic ingredients?
                        </button>
                    </h2>
                    <div id="flush-collapseEight" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingEight" data-bs-parent="#accordionFlushExample3">
                        <div class="accordion-body"> Organic ingredients are grown and processed without synthetic
                            pesticides, fertilizers, or genetically modified organisms (GMOs). Non-organic ingredients
                            may be produced using conventional farming methods. </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingNine">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseNine" aria-expanded="false"
                            aria-controls="flush-collapseNine">
                            3. How do I know if an ingredient is vegan?
                        </button>
                    </h2>
                    <div id="flush-collapseNine" class="accordion-collapse collapse" aria-labelledby="flush-headingNine"
                        data-bs-parent="#accordionFlushExample3">
                        <div class="accordion-body"> Vegan ingredients are derived from plants and do not contain any
                            animal products or by-products. Check the product label or look for vegan certification to
                            ensure an ingredient meets these criteria.
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <!--  -->


        <div class="tab-pane fade" id="recipes" role="tabpanel" aria-labelledby="pills-recipes-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample4">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingEleven">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseEleven" aria-expanded="true"
                            aria-controls="flush-collapseSeven">
                            1. What cuisines can I generate on Nutri AI
                        </button>
                    </h2>
                    <div id="flush-collapseEleven" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingEleven" data-bs-parent="#accordionFlushExample4">
                        <div class="accordion-body">
                            Nutri AI currently supports recipes from the following cuisines - North Indian, South
                            Indian, Gujarati, Bengali, Maharashtrian, Goan, Italian, Mexican, Chinese, Thai
                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwelve">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwelve" aria-expanded="false"
                            aria-controls="flush-collapseTwelve">
                            2. Are all fats bad for you?
                        </button>
                    </h2>
                    <div id="flush-collapseTwelve" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingTwelve" data-bs-parent="#accordionFlushExample4">
                        <div class="accordion-body"> No, not all fats are bad. Healthy fats, such as those found in
                            avocados, nuts, seeds, and olive oil, are beneficial for your heart and overall health. It's
                            best to limit saturated and trans fats found in processed foods and fatty meats. </div>
                    </div>
                </div>


                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headinThirteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThirteen" aria-expanded="false"
                            aria-controls="flush-collapseThirteen">
                            3. What are some plant-based protein sources in my food
                        </button>
                    </h2>
                    <div id="flush-collapseThirteen" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingThirteen" data-bs-parent="#accordionFlushExample4">
                        <div class="accordion-body">
                            Plant-based protein sources include: <br>

                            Beans and lentils <br>
                            Tofu and tempeh<br>
                            Quinoa<br>
                            Nuts and seeds<br>
                            Chickpeas<br>
                            Peas<br>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--  -->


        <div class="tab-pane fade" id="cooking" role="tabpanel" aria-labelledby="pills-cooking-tab">


            <div class="accordion accordion-flush" id="accordionFlushExample5">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFourteen">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFourteen" aria-expanded="true"
                            aria-controls="flush-collapseFourteen">
                            1. What is the difference between baking, roasting, and broiling?
                        </button>
                    </h2>
                    <div id="flush-collapseFourteen" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingFourteen" data-bs-parent="#accordionFlushExample5">
                        <div class="accordion-body">
                            Baking: Cooking food with dry heat in an oven at moderate temperatures. <br>
                            Roasting: Similar to baking but typically at higher temperatures and used for meats and
                            vegetables to achieve a browned exterior. <br>
                            Broiling: Cooking food with high heat from above, ideal for quickly cooking or browning the
                            top of dishes. <br>

                        </div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFifteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFifteen" aria-expanded="false"
                            aria-controls="flush-collapseFifteen">
                            2. How do I properly season my food?
                        </button>
                    </h2>
                    <div id="flush-collapseFifteen" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingFifteen" data-bs-parent="#accordionFlushExample5">
                        <div class="accordion-body"> Start with a small amount of salt and pepper, and adjust to taste.
                            Add fresh herbs and spices during the cooking process to build layers of flavor.
                            Taste your food periodically and adjust seasoning as needed.
                        </div>
                    </div>
                </div>


                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headinSixteen">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSixteen" aria-expanded="false"
                            aria-controls="flush-collapseSixteen">
                            3. What are some healthy cooking techniques?
                        </button>
                    </h2>
                    <div id="flush-collapseSixteen" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingSixteen" data-bs-parent="#accordionFlushExample5">
                        <div class="accordion-body">

                            Steaming: Cooks food quickly and retains nutrients. <br>
                            Grilling: Adds flavor without extra fat. <br>
                            Sautéing: Uses minimal oil for quick cooking. <br>
                            Baking: A healthier alternative to frying. <br>


                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <footer>
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-text">
                    Join our Community to receive tastier and healthier recipes
                </div>
                <div class="footer-form">
                    <form action="send_email.php" method="post">
                        <input type="text" name="name" placeholder="Name" required>
                        <input type="text" id="contact" placeholder="Contact Number" name="contact" maxlength="10"
                            oninput="filterNonNumeric(this);" onblur="validateContact();">
                        <button type="submit" name="submit" style=" background: #B90101;
    border: none;">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="footer-placeholder">
            PLACEHOLDER FOR FOOTER
        </div>
    </footer>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

    <script>

        $(document).ready(function () {
            $('.dietary-button').on('click', function () {
                var ingredient = $(this).data('value');
                var ingredientsInput = $('#ingredientsList');
                var currentIngredients = ingredientsInput.val();
                var ingredientsArray = currentIngredients ? currentIngredients.split(',').map(item => item.trim()) : [];

                if (!ingredientsArray.includes(ingredient)) {
                    ingredientsArray.push(ingredient);
                    ingredientsInput.val(ingredientsArray.join(', '));

                    $(this).html(ingredient + ' <span class="badge check-mark" style="color: green;">&#x2713;</span>');

                } else {
                    ingredientsArray = ingredientsArray.filter(item => item !== ingredient);
                    ingredientsInput.val(ingredientsArray.join(', '));

                    $(this).html(ingredient + ' <span class="badge" style="color: red;"></span>');

                    $(this).removeClass('selected').addClass('removed');
                }
            });
        });

        const micBtn = document.getElementById('micBtn');
        const searchInput = document.getElementById('additional_instructions');

        if ('SpeechRecognition' in window || 'webkitSpeechRecognition' in window) {
            const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
            const recognition = new SpeechRecognition();

            recognition.onresult = (event) => {
                const transcript = event.results[0][0].transcript;
                searchInput.value = transcript;
                findRecipe(transcript);
            };

            micBtn.addEventListener('click', () => {
                micBtn.disabled = true;
                recognition.start();

                recognition.onend = () => {
                    micBtn.disabled = false;
                };

                recognition.onerror = (event) => {
                    console.error('Speech recognition error:', event.error);
                    alert('Speech recognition error. Please try again.');
                    micBtn.disabled = false;
                };
            });
        } else {
            micBtn.disabled = true;
            alert('Speech recognition is not supported in this browser.');
        }

        function findRecipe(query) {
            console.log('Searching for recipe:', query);
        }


        window.addEventListener('scroll', function () {
            var nav = document.querySelector('nav');
            if (window.scrollY > 0) {
                nav.classList.add('nav-sticky');
            } else {
                nav.classList.remove('nav-sticky');
            }
        });

        function toggleLabel() {
            const toggle = document.getElementById('toggle');
            const label = document.getElementById('toggle-label');

            // label.textContent = toggle.checked ? 'Not Necessarily Veg' : 'Veg Only';
        }

    </script>

    </script>

</body>

</html>