<!DOCTYPE html>
<html>
<head>
    <title><?php echo e($recipe['recipe_title']); ?></title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1><?php echo e($recipe['recipe_title']); ?></h1>
        <p><?php echo e($recipe['recipe_description']); ?></p>
        <p><strong>Cooking Time:</strong> <?php echo e($recipe['cooking_time']); ?> minutes</p>
        <p><strong>Preparation Time:</strong> <?php echo e($recipe['preparation_time']); ?> minutes</p>
        <p><strong>Number of Servings:</strong> <?php echo e($recipe['number_of_servings']); ?></p>

        <?php if(!empty($recipe['required_cookware'])): ?>
            <h2>Required Cookware</h2>
            <ul>
                <?php $__currentLoopData = $recipe['required_cookware']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cookware): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($cookware); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endif; ?>

        <?php if(!empty($recipe['ingredient_list'])): ?>
            <h2>Ingredients</h2>
            <ul>
                <?php $__currentLoopData = $recipe['ingredient_list']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ingredient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($ingredient); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        <?php endif; ?>

        <?php if(!empty($recipe['directions'])): ?>
            <h2>Directions</h2>
            <ol>
                <?php $__currentLoopData = $recipe['directions']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $direction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <strong><?php echo e($direction['step_name']); ?>:</strong>
                        <?php echo e($direction['instructions']); ?>

                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ol>
        <?php endif; ?>
    </div>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\Nutri.AI Recipe Generator\cooking-recipe\resources\views/recipe_result.blade.php ENDPATH**/ ?>