<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nutri-second.AI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300..900&display=swap" rel="stylesheet">
</head>

<body>
    <nav>
        <div class="logo">
            <img src="{{ asset('assets/images/nutri.ai.png') }}" alt="Icon">
            <span>Nutri.AI</span>
        </div>
    </nav>
    <hr style="border-top: 1px solid #000;margin: 10px 0;width: 80%;">
    <div class="prev-button">
        <img src="{{ asset('assets/images/back-to.png') }}" alt="back-to">
        <button class="uniq-pre">Previous</button>
    </div>

    <div class="m-5 d-flex justify-content-center">
        <h1 class="main-title w-md-75">
            Create a recipe using <br> ingredients of your preference:
        </h1>
    </div>

    <!-- <div class="col-2">
    <label class="switch">
        <input type="checkbox" id="vegToggle" onchange="toggleVegNonVeg()">
        <span class="slider round"></span>
    </label>
    <div id="toggle-label" class="toggle-label">Vegetarian</div>
</div> -->

<div style="max-width: 1000px; width: 100%;">
    <form action="{{ route('recipe2.generate') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="d-flex justify-content-end align-items-center">
            <div class="toggle-container">
                <label class="switch">
                    <input type="checkbox" id="toggle" onchange="toggleLabel()" name="veg_only">
                    <span class="slider round"></span>
                </label>
                <span id="toggle-label" class="toggle-label">Veg Only</span>
            </div>
        </div>

        <div class="search-box" style="padding: 3px; max-width: 1000px; margin: 10px 0; padding: 10px">
            <i class="fa fa-search"></i>
            <input type="text" class="form-control no-outline" id="additional_instructions"
                placeholder="Create a recipe for paneer butter masala..." name="additional_instructions"
                style="width: calc(100% - 40px); margin-right: 5px;">
            <button id="micBtn" style="border: none; background: transparent; cursor: pointer;">
                <img src="{{ asset('assets/images/mic-phone.png') }}" alt="Mic" style="width: 24px; height: 24px;">
            </button>

            <button type="button" onclick="document.getElementById('imageInput').click()"
                style="border: none; background: transparent; cursor: pointer;">
                <img src="{{ asset('assets/images/upload-image.png') }}" alt="upload-image"
                    style="width: 24px; height: 24px;">
            </button>
            <input type="file" id="imageInput" accept="image/*" name="image" style="display: none;">
        </div>

        <div class="card rcard my-5">
            <div class="form-group row">
                <label for="ingredientsList" class="col-1 col-form-label text-end">
                    <div class="dot">1</div>
                </label>
                <div class="col-11">
                    <input type="text" class="form-control" id="ingredientsList"
                        placeholder="Search or add ingredients" name="ingredients">
                    <p><strong>Most commonly used ingredients:</strong> (Select from the list to add ingredients)</p>
                    <div id="ingredientButtons">
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Chicken">Chicken <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Tomato Puree">Tomato Puree <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Green Chillies">Green Chillies <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Turmeric Powder">Turmeric Powder <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Fresh Cream">Fresh Cream <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Ginger-Garlic Paste">Ginger-Garlic Paste <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Besan">Besan <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Pure Ghee">Pure Ghee <span class="badge" style="color: red;"></span></button>
                        <button type="button" class="btn border border-dark bg-white m-1 dietary-button"
                            data-value="Butter">Butter <span class="badge" style="color: red;"></span></button>
                    </div>
                </div>
            </div>

            <div class="form-group row mt-3">
                <label for="meal_type" class="col-1 col-form-label text-end">
                    <div class="dot">2</div>
                </label>
                <div class="col-11">
                    <select class="form-control" id="mealtype" name="meal_type">
                        <option value="">Select your meal</option>
                        <option value="Breakfast">Breakfast</option>
                        <option value="Lunch">Lunch</option>
                        <option value="Dinner">Dinner</option>
                    </select>
                </div>
            </div>

            <div class="form-group row mt-3">
                <label for="cuisine" class="col-1 col-form-label text-end">
                    <div class="dot">3</div>
                </label>
                <div class="col-11">
                    <select class="form-control" id="cuisine" name="cuisine">
                        <option value="">Select your cuisine</option>
                        <option value="North Indian">North Indian</option>
                        <option value="South Indian">South Indian</option>
                        <option value="Italian">Italian</option>
                        <option value="Chinese">Chinese</option>
                    </select>
                </div>
            </div>

            <div class="col-12" style="padding-top: 2rem;">
                <button type="submit" class="btn btn-dark btn-lg btn-block w-100">Generate Recipe</button>
            </div>
        </div>
    </form>
</div>


    <div class="ai-suggestion ms-3">
        <form action="{{ route('recipe2.generate') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <button onclick="suggestRecipe()" style="border-radius: 10px;">
                   <img src="{{ asset('assets/images/get-ai-to-suggest-you-a-recipe.png') }}"
                    alt="get-ai-to-suggest-you-a-recipe" style="width: 30px; height: 30px; ">
                Get AI to Suggest You a Recipe →
            </button>
    </div>



    <div id="loginModal" class="modal">
        <div class="modal-content">
            <span class="close">&times;</span>
            <h2 class="pop-head">Enter Your Details</h2>
            <form id="loginForm" class="pop-ip">
                <input type="text" id="name" name="name" placeholder="Full Name"><br>
                <input type="email" id="email" name="email" placeholder="Email"><br>
                <input type="tel" id="mobile" name="mobile" placeholder="Mobile"><br>
                <button type="submit" id="googleLogin">Submit</button>
            </form>
        </div>
    </div>
    <hr class="w-75">

    <div class="m-5 justify-content-center align-items-center faq-sec">
        <h2>Frequently Asked<br>Questions</h2>
    </div>
    <ul class="nav nav-pills mb-3 d-flex justify-content-center" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2 active" id="pills-home-tab" data-bs-toggle="pill"
                href="#general" role="tab" aria-controls="pills-home" aria-selected="true">General</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-profile-tab" data-bs-toggle="pill"
                href="#food" role="tab" aria-controls="pills-profile" aria-selected="false">Food</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-contact-tab" data-bs-toggle="pill"
                href="#ingredients" role="tab" aria-controls="pills-contact" aria-selected="false">Ingredients</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-recipes-tab" data-bs-toggle="pill"
                href="#recipes" role="tab" aria-controls="pills-recipes" aria-selected="false">Recipes</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-cooking-tab" data-bs-toggle="pill"
                href="#cooking" role="tab" aria-controls="pills-cooking" aria-selected="false">Cooking</a>
        </li>
    </ul>
    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="pills-home-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample1">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
                            1. How much coffee is too much coffee?
                        </button>
                    </h2>
                    <div id="flush-collapseOne" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                            2. How do I choose the right diet plan?
                        </button>
                    </h2>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo"
                        data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseThree" aria-expanded="false"
                            aria-controls="flush-collapseThree">
                            3. What are some good sources of protein for vegetarians?
                        </button>
                    </h2>
                    <div id="flush-collapseThree" class="accordion-collapse collapse"
                        aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="food" role="tabpanel" aria-labelledby="pills-profile-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample2">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFour" aria-expanded="true"
                            aria-controls="flush-collapseFour">
                            1. What are the benefits of a Mediterranean diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse show"
                        aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseFive" aria-expanded="false"
                            aria-controls="flush-collapseFive">
                            2. How can I reduce sugar in my diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#flush-collapseSix" aria-expanded="false" aria-controls="flush-collapseSix">
                            3. What are some healthy snacks for weight loss?
                        </button>
                    </h2>
                    <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix"
                        data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion.</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="tab-pane fade" id="ingredients" role="tabpanel" aria-labelledby="pills-contact-tab">
            Ingredients content.
        </div>
        <div class="tab-pane fade" id="recipes" role="tabpanel" aria-labelledby="pills-recipes-tab">
            Recipes content.
        </div>
        <div class="tab-pane fade" id="cooking" role="tabpanel" aria-labelledby="pills-cooking-tab">
            Cooking content.
        </div>
    </div>

    <footer>
        <div class="footer-container">
            <div class="footer-content">
                <div class="footer-text">
                    Join our Community to receive tastier and healthier recipes
                </div>
                <div class="footer-form">
                    <form>
                        <input type="text" name="name" placeholder="Name" required>
                        <input type="text" id="contact" placeholder="Contact Number" name="contact" maxlength="10"
                            oninput="filterNonNumeric(this);" onblur="validateContact();">
                        <button type="submit" style=" background: #B90101; border: none;">Submit</button>
                    </form>
                </div>
            </div>
        </div>
        <div class="footer-placeholder">
            PLACEHOLDER FOR FOOTER
        </div>
    </footer>


    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

    <script>

$(document).ready(function () {
    $('.dietary-button').on('click', function () {
        var ingredient = $(this).data('value');
        var ingredientsInput = $('#ingredientsList');
        var currentIngredients = ingredientsInput.val();
        var ingredientsArray = currentIngredients ? currentIngredients.split(',').map(item => item.trim()) : [];

        if (!ingredientsArray.includes(ingredient)) {
            ingredientsArray.push(ingredient);
            ingredientsInput.val(ingredientsArray.join(', '));

            $(this).html(ingredient + ' <span class="badge check-mark" style="color: green;">&#x2713;</span>');

        } else {
            ingredientsArray = ingredientsArray.filter(item => item !== ingredient);
            ingredientsInput.val(ingredientsArray.join(', '));

            $(this).html(ingredient + ' <span class="badge" style="color: red;"></span>');

            $(this).removeClass('selected').addClass('removed');
        }
    });
});

            const micBtn = document.getElementById('micBtn');
            const searchInput = document.getElementById('additional_instructions');

            if ('SpeechRecognition' in window || 'webkitSpeechRecognition' in window) {
                const SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;
                const recognition = new SpeechRecognition();

                recognition.onresult = (event) => {
                    const transcript = event.results[0][0].transcript;
                    searchInput.value = transcript;
                    findRecipe(transcript);
                };

                micBtn.addEventListener('click', () => {
                    micBtn.disabled = true;
                    recognition.start();

                    recognition.onend = () => {
                        micBtn.disabled = false;
                    };

                    recognition.onerror = (event) => {
                        console.error('Speech recognition error:', event.error);
                        alert('Speech recognition error. Please try again.');
                        micBtn.disabled = false;
                    };
                });
            } else {
                micBtn.disabled = true;
                alert('Speech recognition is not supported in this browser.');
            }

            function findRecipe(query) {
                console.log('Searching for recipe:', query);
            }


            window.addEventListener('scroll', function () {
                var nav = document.querySelector('nav');
                if (window.scrollY > 0) {
                    nav.classList.add('nav-sticky');
                } else {
                    nav.classList.remove('nav-sticky');
                }
            });

        function toggleLabel() {
            const toggle = document.getElementById('toggle');
            const label = document.getElementById('toggle-label');

           // label.textContent = toggle.checked ? 'Not Necessarily Veg' : 'Veg Only';
        }

    </script>

    </script>

</body>

</html>