<!DOCTYPE html>
<html>
<head>
    <title>Generate Recipe</title>
    <!-- Include Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1 class="mb-4 text-center">Generate a Recipe</h1>

        @if ($errors->any())
            <div class="alert alert-danger">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="/recipe" method="POST">
            @csrf
            <div class="form-group">
                <label for="ingredients">Ingredients (comma-separated):</label>
                <input type="text" name="ingredients" class="form-control">
            </div>
            <div class="form-group">
                <label for="cuisine">Cuisine:</label>
                <select name="cuisine" class="form-control" >
                    <option value="North Indian">North Indian</option>
                    <option value="South Indian">South Indian</option>
                    <option value="Gujarati">Gujarati</option>
                    <option value="Bengali">Bengali</option>
                    <option value="Maharashtrian">Maharashtrian</option>
                    <option value="Goan">Goan</option>
                    <option value="Italian">Italian</option>
                    <option value="Mexican">Mexican</option>
                    <option value="Chinese">Chinese</option>
                    <option value="Thai">Thai</option>
                </select>
            </div>
            <div class="form-group">
                <label for="meal_type">Meal Type:</label>
                <select name="meal_type" class="form-control" >
                    <option value="Breakfast">Breakfast</option>
                    <option value="Lunch">Lunch</option>
                    <option value="Dinner">Dinner</option>
                    <option value="Snack">Snack</option>
                    <option value="Dessert">Dessert</option>
                </select>
            </div>
            <div class="form-group">
                <label for="difficulty">Difficulty:</label>
                <select name="difficulty" class="form-control" >
                    <option value="Beginner">Beginner</option>
                    <option value="Intermediate">Intermediate</option>
                    <option value="Advanced">Advanced</option>
                </select>
            </div>
            <div class="form-group">
                <label for="cooking_time">Cooking Time:</label>
                <select name="cooking_time" class="form-control" >
                    <option value="Under 30 minutes">Under 30 minutes</option>
                    <option value="30-60 minutes">30-60 minutes</option>
                    <option value="60–90 minutes">60–90 minutes</option>
                    <option value="Over 90 minutes">Over 90 minutes</option>
                </select>
            </div>
            <div class="form-group">
                <label for="dietary_restrictions">Dietary Restrictions:</label>
                <select name="dietary_restrictions[]" class="form-control" multiple >
                    <option value="Vegetarian">Vegetarian</option>
                    <option value="Gluten-free">Gluten-free</option>
                    <option value="Diabetic-friendly">Diabetic-friendly</option>
                    <option value="Low-calorie">Low-calorie</option>
                    <option value="High-protein">High-protein</option>
                </select>
            </div>
            <div class="form-group">
                <label for="servings">Number of Servings:</label>
                <input type="number" name="servings" class="form-control" >
            </div>
            <div class="form-group">
                <label for="veg_nonveg">Veg/Non-Veg:</label>
                <select name="veg_nonveg" class="form-control" >
                    <option value="Veg">Vegetarian</option>
                    <option value="Non-Veg">Non Vegetarian</option>
                </select>
            </div>
            <div class="form-group">
                <label for="additional_instructions">Additional Instructions:</label>
                <textarea name="additional_instructions" class="form-control"></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Submit and Generate Recipe</button>
        </form>
    </div>
</body>
</html>
