<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nutri.AI</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="http://localhost/nutri-ai/public/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Frank+Ruhl+Libre:wght@300..900&display=swap" rel="stylesheet">
    <script>
        function filterNonNumeric(input) {
            // Remove non-numeric characters
            input.value = input.value.replace(/\D/g, '');
        }

        function validateContact() {
            const contactInput = document.getElementById('contact');
            const contactValue = contactInput.value;
            const contactPattern = /^[0-9]{10}$/;

            if (!contactPattern.test(contactValue)) {
                alert('Please enter a valid 10-digit contact number.');
                return false;
            }
            return true;
        }

        function loadFooter() {
            fetch('footer.html')
                .then(response => response.text())
                .then(data => {
                    document.getElementById('footer-placeholder').innerHTML = data;
                })
                .catch(error => console.error('Error loading footer:', error));
        }

        // Voice search functionality using Web Speech API
        function initializeVoiceSearch() {
            if ('webkitSpeechRecognition' in window) {
                const recognition = new webkitSpeechRecognition();
                recognition.continuous = false;
                recognition.interimResults = false;
                recognition.lang = 'en-US';

                recognition.onstart = function() {
                    console.log('Voice recognition started.');
                };

                recognition.onerror = function(event) {
                    console.error('Error occurred in recognition: ', event.error);
                };

                recognition.onend = function() {
                    console.log('Voice recognition ended.');
                };

                recognition.onresult = function(event) {
                    const transcript = event.results[0][0].transcript;
                    document.getElementById('searchInput').value = transcript;
                    console.log('Recognized text: ', transcript);
                };

                document.getElementById('micBtn').addEventListener('click', () => {
                    recognition.start();
                });
            } else {
                alert('Voice search is not supported in your browser.');
            }
        }

        document.addEventListener('DOMContentLoaded', () => {
            initializeVoiceSearch();

            document.getElementById('imageInput').addEventListener('change', () => {
                const file = document.getElementById('imageInput').files[0];
                if (file) {
                    alert('Image upload not implemented yet.');
                }
            });

            document.querySelector('.ai-suggestion button').addEventListener('click', suggestRecipe);
        });

        function suggestRecipe() {
            const selectedIngredients = Array.from(document.querySelectorAll('input[name="ingredient"]:checked')).map(cb => cb.value);
            const selectedCuisines = Array.from(document.querySelectorAll('input[name="cuisine"]:checked')).map(cb => cb.value);

            const apiUrl = 'https://yourapi.com/suggest-recipe';
            
            const data = {
                ingredients: selectedIngredients,
                cuisines: selectedCuisines
            };

            fetch(apiUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json'
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(data => {
                alert('Suggested Recipe: ' + JSON.stringify(data));
            })
            .catch(error => {
                console.error('Error:', error);
            });
        }
    </script>
</head>
<body onload="loadFooter()">

    <div class="m-5 d-flex justify-content-center align-items-center icon-text">
        <img src="http://localhost/nutri-ai/public/assets/image/nutri.ai.png" alt="nutri.ai" width="67" height="67">
        <span>Nutri.Ai</span>
    </div>

    <div class="m-3 justify-content-center align-items-center craft">
        <h2>Craft Culinary Delights with AI:<br>Explore Endless Recipe Possibilities!</h2>
    </div>
    <!-- search-box Section -->
    <div class="search-box">
        <i class="fa fa-search"></i>
        <input type="text" id="searchInput" placeholder="Create a recipe for paneer butter masala...">
        <button id="micBtn">
            <img src="http://localhost/nutri-ai/public/assets/image/mic-phone.png" alt="Mic">
        </button>
        <button onclick="document.getElementById('imageInput').click()">
            <img src="http://localhost/nutri-ai/public/assets/image/upload-image.png" alt="upload-image">
        </button>
        <input type="file" id="imageInput" accept="image/*">
    </div>
    <!-- search-box Section End-->

    <!-- Recipe Cards Section -->
    <div class="recipe-container">
        <div class="recipe-card">
            <div class="card-content">
                <h2>Create a Recipe</h2>
                <p>based on main ingredients</p>
                <div class="tags">
                    <label>Chicken<input type="checkbox" name="ingredient" value="Chicken"></label>
                    <label>Fish<input type="checkbox" name="ingredient" value="Fish"></label>
                    <label>Eggs<input type="checkbox" name="ingredient" value="Eggs"></label>
                    <label>Lamb<input type="checkbox" name="ingredient" value="Lamb"></label>
                    <label>Pulses<input type="checkbox" name="ingredient" value="Pulses"></label>
                    <label>Soya<input type="checkbox" name="ingredient" value="Soya"></label>
                    <label>Bread<input type="checkbox" name="ingredient" value="Bread"></label>
                    <label>Herbs<input type="checkbox" name="ingredient" value="Herbs"></label>
                    <label>Tomato<input type="checkbox" name="ingredient" value="Tomato"></label>
                    <label>Rice<input type="checkbox" name="ingredient" value="Rice"></label>
                    <label>Rajma<input type="checkbox" name="ingredient" value="Rajma"></label>
                    <label>Potato<input type="checkbox" name="ingredient" value="Potato"></label>
                    <label>Broccoli<input type="checkbox" name="ingredient" value="Broccoli"></label>
                </div>
                <div class="arrow">→</div>
            </div>
        </div>
        <div class="recipe-card">
            <div class="card-content">
                <h2>Create a Recipe</h2>
                <p>based on a specific cuisine</p>
                <div class="tags">
                    <label>Indian<input type="checkbox" name="cuisine" value="Indian"></label>
                    <label>Continental<input type="checkbox" name="cuisine" value="Continental"></label>
                    <label>Italian<input type="checkbox" name="cuisine" value="Italian"></label>
                    <label>Thai<input type="checkbox" name="cuisine" value="Thai"></label>
                    <label>Mediterranean<input type="checkbox" name="cuisine" value="Mediterranean"></label>
                    <label>Chinese<input type="checkbox" name="cuisine" value="Chinese"></label>
                    <label>Lebanese<input type="checkbox" name="cuisine" value="Lebanese"></label>
                    <label>French<input type="checkbox" name="cuisine" value="French"></label>
                    <label>Greek<input type="checkbox" name="cuisine" value="Greek"></label>
                    <label>Spanish<input type="checkbox" name="cuisine" value="Spanish"></label>
                    <label>Japanese<input type="checkbox" name="cuisine" value="Japanese"></label>
                </div>
                <div class="arrow">→</div>
            </div>
        </div>
    </div>
    <!-- AI Suggestion Button -->
    <div class="ai-suggestion">
        <button onclick="suggestRecipe()"><img src="http://localhost/nutri-ai/public/assets/image/get-ai-to-suggest-you-a-recipe.png" alt="get-ai-to-suggest-you-a-recipe" style="width: 30px;height: 30px;">Get AI to Suggest You a Recipe →</button>
    </div>
    <hr class="w-75">
    <!-- faq start -->
    <div class="m-5 justify-content-center align-items-center faq-sec">
        <h2>Frequently Asked<br>Questions</h2>
    </div>

    <ul class="nav nav-pills justify-content-center align-items-center" id="pills-tab" role="tablist">
        <li class="nav-item">
            <a class="nav-link active text-dark rounded-pill border m-2" id="pills-home-tab" data-bs-toggle="pill" href="#general" role="tab" aria-controls="pills-home" aria-selected="true">General</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-profile-tab" data-bs-toggle="pill" href="#food" role="tab" aria-controls="pills-profile" aria-selected="false">Food</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-contact-tab" data-bs-toggle="pill" href="#ingredients" role="tab" aria-controls="pills-contact" aria-selected="false">Ingredients</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-recipes-tab" data-bs-toggle="pill" href="#recipes" role="tab" aria-controls="pills-recipes" aria-selected="false">Recipes</a>
        </li>
        <li class="nav-item">
            <a class="nav-link text-dark rounded-pill border m-2" id="pills-cooking-tab" data-bs-toggle="pill" href="#cooking" role="tab" aria-controls="pills-cooking" aria-selected="false">Cooking</a>
        </li>
    </ul>
    <!-- General tab start -->
    <div class="tab-content" id="pills-tabContent">
        <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="pills-home-tab">
            <!-- General faq start -->
            <div class="accordion accordion-flush" id="accordionFlushExample1">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingOne">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="true" aria-controls="flush-collapseOne">
                            1. How much coffee is too much coffee?  
                        </button>
                    </h2>
                    <div id="flush-collapseOne" class="accordion-collapse collapse show" aria-labelledby="flush-headingOne" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the first item's accordion body.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingTwo">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseTwo" aria-expanded="false" aria-controls="flush-collapseTwo">
                          2. How do I choose the right diet plan?
                        </button>
                    </h2>
                    <div id="flush-collapseTwo" class="accordion-collapse collapse" aria-labelledby="flush-headingTwo" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the second item's accordion body. Let's imagine this being filled with some actual content.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingThree">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseThree" aria-expanded="false" aria-controls="flush-collapseThree">
                          3. What are some good sources of protein for vegetarians?
                        </button>
                    </h2>
                    <div id="flush-collapseThree" class="accordion-collapse collapse" aria-labelledby="flush-headingThree" data-bs-parent="#accordionFlushExample1">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the third item's accordion body. Nothing more exciting happening here in terms of content, but just filling up the space to make it look, at least at first glance, a bit more representative of how this would look in a real-world application.</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- General tab end -->
        
        <!-- Food tab start -->
        <div class="tab-pane fade" id="food" role="tabpanel" aria-labelledby="pills-profile-tab">
            <div class="accordion accordion-flush" id="accordionFlushExample2">
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseFour" aria-expanded="true" aria-controls="flush-collapseFour">
                          1. What are the benefits of a Mediterranean diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFour" class="accordion-collapse collapse show" aria-labelledby="flush-headingFour" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the first item's accordion body.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingFive">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseFive" aria-expanded="false" aria-controls="flush-collapseFive">
                          2. How can I reduce sugar in my diet?
                        </button>
                    </h2>
                    <div id="flush-collapseFive" class="accordion-collapse collapse" aria-labelledby="flush-headingFive" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the second item's accordion body. Let's imagine this being filled with some actual content.</div>
                    </div>
                </div>
                <div class="accordion-item">
                    <h2 class="accordion-header" id="flush-headingSix">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseSix" aria-expanded="false" aria-controls="flush-collapseSix">
                          3. What are some healthy snacks for weight loss?
                        </button>
                    </h2>
                    <div id="flush-collapseSix" class="accordion-collapse collapse" aria-labelledby="flush-headingSix" data-bs-parent="#accordionFlushExample2">
                        <div class="accordion-body">Placeholder content for this accordion, which is intended to demonstrate the <code>.accordion-flush</code> class. This is the third item's accordion body. Nothing more exciting happening here in terms of content, but just filling up the space to make it look, at least at first glance, a bit more representative of how this would look in a real-world application.</div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Food tab end -->

        <div class="tab-pane fade" id="ingredients" role="tabpanel" aria-labelledby="pills-contact-tab">
            Ingredients content.
        </div>
        <div class="tab-pane fade" id="recipes" role="tabpanel" aria-labelledby="pills-recipes-tab">
            Recipes content.
        </div>
        <div class="tab-pane fade" id="cooking" role="tabpanel" aria-labelledby="pills-cooking-tab">
            Cooking content.
        </div>
    </div>


    <!-- footer.html -->
  


    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.min.js"></script>
</body>
</html>
