<!DOCTYPE html>
<html>
<head>
    <title>{{ $recipe['recipe_title'] }}</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1>{{ $recipe['recipe_title'] }}</h1>
        <p>{{ $recipe['recipe_description'] }}</p>
        <p><strong>Cooking Time:</strong> {{ $recipe['cooking_time'] }} minutes</p>
        <p><strong>Preparation Time:</strong> {{ $recipe['preparation_time'] }} minutes</p>
        <p><strong>Number of Servings:</strong> {{ $recipe['number_of_servings'] }}</p>

        @if(!empty($recipe['required_cookware']))
            <h2>Required Cookware</h2>
            <ul>
                @foreach($recipe['required_cookware'] as $cookware)
                    <li>{{ $cookware }}</li>
                @endforeach
            </ul>
        @endif

        @if(!empty($recipe['ingredient_list']))
            <h2>Ingredients</h2>
            <ul>
                @foreach($recipe['ingredient_list'] as $ingredient)
                    <li>{{ $ingredient }}</li>
                @endforeach
            </ul>
        @endif

        @if(!empty($recipe['directions']))
            <h2>Directions</h2>
            <ol>
                @foreach($recipe['directions'] as $direction)
                    <li>
                        <strong>{{ $direction['step_name'] }}:</strong>
                        {{ $direction['instructions'] }}
                    </li>
                @endforeach
            </ol>
        @endif
    </div>
</body>
</html>
