<?php

$apiKey = 'qurhis-1ohvej-Jugdoc';
$workflow = '83526349-f09a-4de8-ae6c-343ce91d27d0';

$data = [
    'workflow' => $workflow,
    'input' => [
        'cuisine' => ['North Indian'],
        'meal_type' => ['Dinner'],
        'difficulty' => 'Intermediate',
        'cooking_time' => '30-60 minutes',
        'dietary_restrictions' => ['Vegetarian'],
        'servings' => 4,
        'additional_instructions' => [
            'veg_nonveg' => 'Veg',
            'prompt' => 'No additional instructions'
        ],
    ],
];

$ch = curl_init('https://hub.peppercontent.io/workflows/v1/run');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'apiKey: ' . $apiKey,
]);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_VERBOSE, true);  // Enable verbose output
$verbose = fopen('php://temp', 'w+');
curl_setopt($ch, CURLOPT_STDERR, $verbose);

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

if ($response === false || $httpCode != 200) {
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);
    $error = curl_error($ch);
    curl_close($ch);
    die('Error occurred: ' . ($error ? $error : 'HTTP Status Code ' . $httpCode) . "\nVerbose information:\n" . $verboseLog);
}

curl_close($ch);
echo $response;
